/*****************************************************************************
 * Project: SCT Application Example for LPC800
 *
 * Implements a start stop event example for the SCT 
 *
 * For this application the following interface pins are used:
 * -------------------------------------------------------------------------
 * Signal    Port               Signal      
 * -------------------------------------------------------------------------
 * CTOUT_0   P0_6   pin 18      COUNTER_L_RUN
 * CTOUT_1   P0_7   pin 17      COUNTER_H_RUN
 * CTOUT_2   P0_8   pin 14      STATE_1
 * CTOUT_3   P0_9   pin 13      STATE_2
 * ------------------------------------------------------------------------*/

#include "LPC8xx.h"
#include "start_stop.h"

int main (void) 
{
    LPC_SWM->PINASSIGN6 = 0x06FFFFFF;          // CTOUT_0 at P0_6
    LPC_SWM->PINASSIGN7 = 0xFF090807;          // CTOUT_1 at P0_7, CTOUT_2 at P0_8 ,CTOUT_3 at P0_9

    start_stop_init();
    
    while (1) 
    {
    }
}


